// V1.0	Original version based on GUI.fx V1.4
// V2.0 - TN - Updated to handle the materials overhaul
// V2.01 - TN - Made sure samplers aren't using anisotropic filtering.
// V2.02 - TN - Converted to on-load rendermode behaviour binding.
//
// Notes :
// only intended for use for rendering into textures, so requirement for inversion control on PS3 / WinGL is gone
// only supports one texture because that is all that is needed for what this should be used for
// doesn't support not having a texture (again, not needed)

// TODO :  remove 4x4 matrix and replace with 3x2 or even sin, cos, scale (x+y) and offset
//         advantage of a full 3x2 is that you can do anything - including skew, which is useful for speed modified splats
//         4x4 doesn't give any advantage, and costs more in every way

//
// Parameters
//

#include "stddefs.fxh"

texture CoreTexture : TEXTURE < bool appEdit = true; >;

float4x4	position_xform < bool appEdit = true; > = {
{1.0f, 0.0f, 0.0f, 0.0f},
{0.0f, 1.0f, 0.0f, 0.0f},
{0.0f, 0.0f, 1.0f, 0.0f},
{0.0f, 0.0f, 0.0f, 1.0f}};
float4 		uv_mul_add < bool appEdit = true; > = {0.5f, 0.5f, 0.5f, 0.5f};		// takes [-1,1] and maps it to [0,1] - can be changed to map to any aligned rectangle though
float4		rgba_modifier < bool appEdit = true; > = {1.0f, 1.0f, 1.0f, 1.0f};	// no colour change
float		z_value < bool appEdit = true; > = {0.0f};
float4		rgba_value < bool appEdit = true; > = {1.0f, 1.0f, 1.0f, 1.0f};	

float4x4	position_array < bool appEdit = true; >;

//-----------------------------------------------------------------------
//
// Samplers
//

sampler2D CoreMap : SAMPLER 
< 
	SET_LINEAR_TEXTURE
	bool appEdit = false; 
	string SamplerTexture="CoreTexture"; 
	string MinFilter = "Linear";
	string MagFilter = "Linear";
	string MipFilter = "None";
> 
= sampler_state
{
	Texture = < CoreTexture >;
#if defined(SET_FX_SAMPLER_STATES)
	FX_SAMPLERSTATE_LINEAR_TEXTURE
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = None;
	SET_NO_ANISOTROPY
#endif
};







//-----------------------------------------------------------------------
//
// Code for technique 'Engine'
//
//
//
//

//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

// Input structure
struct VSINPUT
{
	float2 position : POSITION;
};


// Output structure (also input to the fragment shader)
struct VSOUTPUT
{
	float4 position	: POSITION;													// View-coords position
	float2 texCoord	: TEXCOORD0;												// UV coords for texture channel 0
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT EngineVertexShader( VSINPUT _input )
{
	VSOUTPUT _output = ( VSOUTPUT )0;

	_output.texCoord = (_input.position.xy * uv_mul_add.xy) + uv_mul_add.zw;

	float4	pos4 = float4( _input.position.xy, 0.0f, 1.0f );
	_output.position.xy = mul(  pos4, position_xform );
	_output.position.y *= -1.0f;				// and y is inverted

	_output.position.z = 0.0f;
	_output.position.w = 1.0f;

	return _output;
}


//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

// Output structure
struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE Colour : COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT EngineFragmentShader( VSOUTPUT _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	// Read textures
	float2	uv = _input.texCoord;
	float4	Colour = tex2D( CoreMap, uv );
	_output.Colour = CalculateOutputPixel(Colour*rgba_modifier);
	//_output.Colour = = float4( 1.0f, 0.5f, 0.25f, 1.0f );	// solid colour test

	return _output;
}








//-----------------------------------------------------------------------
//
// Code for technique 'EngineZNoTex'
//
//
//
//

//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

// Input structure
struct VSINPUT_ZNOTEX
{
	float2 position : POSITION;
};

// Output structure (also input to the fragment shader)
struct VSOUTPUT_ZNOTEX
{
	float4 position	: POSITION;													// View-coords position
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT_ZNOTEX EngineVertexShaderZNoTex( VSINPUT_ZNOTEX _input )
{
	VSOUTPUT_ZNOTEX _output = ( VSOUTPUT_ZNOTEX )0;

	float4	pos4 = float4( _input.position.xy, 0.0f, 1.0f );
	_output.position.xy = mul(  pos4, position_xform );
	_output.position.y *= -1.0f;				// and y is inverted

	_output.position.z = z_value;
	_output.position.w = 1.0f;

	return _output;
}



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT EngineFragmentShaderZNoTex( VSOUTPUT_ZNOTEX _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	_output.Colour = rgba_value;
	
	return _output;
}







//-----------------------------------------------------------------------
//
// Code for technique 'EngineQuadNoTex'
//
//
//
//

//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

// Input structure
struct VSINPUT_QUADNOTEX
{
	float3 position : POSITION;
};


// Output structure (also input to the fragment shader)
struct VSOUTPUT_QUADNOTEX
{
	float4 position	: POSITION;													// View-coords position
};



//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT_QUADNOTEX EngineVertexShaderQuadNoTex( VSINPUT_QUADNOTEX _input )
{
	VSOUTPUT_QUADNOTEX _output = ( VSOUTPUT_QUADNOTEX )0;
	
	int vertexIdx = (int)_input.position.x;

	float4	pos4 = float4( position_array[vertexIdx].xy, 0.0f, 1.0f );
	_output.position.xy = mul( pos4, position_xform );
	_output.position.y *= -1.0f;				
	_output.position.z = 0.0f;
	_output.position.w = 1.0f;

	return _output;
}



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT EngineFragmentShaderQuadNoTex( VSOUTPUT_QUADNOTEX _input )
{
	PSOUTPUT _output = ( PSOUTPUT )0;

	_output.Colour = rgba_value;
		
	return _output;
}








//-----------------------------------------------------------------------
//
// Technique(s)
//

technique Engine
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "Engine";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
#ifdef _PS3_
		VertexShader = compile sce_vp_rsx EngineVertexShader();
		PixelShader = compile sce_fp_rsx EngineFragmentShader();
#else		
		VertexShader = compile vs_3_0 EngineVertexShader();
		PixelShader = compile ps_3_0 EngineFragmentShader();
#endif
	}
}

technique EngineZNoTex
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "EngineZNoTex";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
#ifdef _PS3_
		VertexShader = compile sce_vp_rsx EngineVertexShaderZNoTex();
		PixelShader = compile sce_fp_rsx EngineFragmentShaderZNoTex();
#else		
		VertexShader = compile vs_3_0 EngineVertexShaderZNoTex();
		PixelShader = compile ps_3_0 EngineFragmentShaderZNoTex();
#endif
	}
}

technique EngineQuadNoTex
<
	bool supportsSpecialisedLighting = false;
	bool preservesGlobalState = true;
	string normalBehaviour		= "ERMB_RENDER";
	string normalTechnique		= "Engine";
	int    normalDeferredID		= 0;
>
{
	pass Pass0
	{
#ifdef _PS3_
		VertexShader = compile sce_vp_rsx EngineVertexShaderQuadNoTex();
		PixelShader = compile sce_fp_rsx EngineFragmentShaderQuadNoTex();
#else		
		VertexShader = compile vs_3_0 EngineVertexShaderQuadNoTex();
		PixelShader = compile ps_3_0 EngineFragmentShaderQuadNoTex();
#endif
	}
}


